/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.apps.designer.VWSIMConfirmDialog;
import filenet.sim.apps.designer.images.VWSIMImageLoader;
import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class VWSIMIDMNewConfirmDialog
extends VWSIMConfirmDialog
implements ActionListener,
IVWDialogButtonsActionListener {
    public static final int STATUS_CHECKIN = 500;
    public static final int STATUS_CANCELCHECKOUT = 501;
    private ImageIcon m_icon = null;
    private JPanel m_msgPanel = null;
    private JLabel m_msg = null;
    private JRadioButton m_checkInRadioButton = null;
    private JRadioButton m_cancelCheckOutRadioButton = null;
    private JLabel m_msg2 = null;
    private VWDialogButtons m_buttons = null;
    private GridBagConstraints m_gbCons = null;

    public VWSIMIDMNewConfirmDialog(Frame parent) {
        super(parent);
        this.m_status = 500;
    }

    public void init() {
        try {
            this.getContentPane().setLayout(new GridBagLayout());
            this.m_gbCons = new GridBagConstraints();
            String title = VWIDMBaseFactory.instance().getVWString(12).toString();
            this.setTitle(title);
            Dimension dim = VWStringUtils.stringToDimension("505,205");
            if (dim != null) {
                this.setSize(dim);
            }
            this.initIcon();
            this.initMsgs();
            this.initButtons();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initIcon() {
        try {
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 0;
            this.m_gbCons.weightx = 0.0;
            this.m_gbCons.weighty = 1.0;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.insets = new Insets(5, 5, 5, 5);
            this.m_gbCons.anchor = 19;
            this.m_gbCons.fill = 0;
            this.m_icon = VWSIMImageLoader.createImageIcon("question.gif");
            this.getContentPane().add((Component)new JLabel(this.m_icon), this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initMsgs() {
        try {
            this.m_gbCons.gridx = 1;
            this.m_gbCons.gridy = 0;
            this.m_gbCons.fill = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 1.0;
            this.m_gbCons.anchor = 23;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.insets = new Insets(5, 5, 5, 5);
            this.m_msgPanel = new JPanel();
            this.getContentPane().add((Component)this.m_msgPanel, this.m_gbCons);
            this.m_msgPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(0, 10, 0, 0);
            this.m_msg = new JLabel(VWSIMResource.s_idmConfirmMsg);
            this.m_msgPanel.add((Component)this.m_msg, gbCons);
            ButtonGroup buttonGroup = new ButtonGroup();
            ++gbCons.gridy;
            gbCons.insets = new Insets(15, 15, 0, 0);
            this.m_checkInRadioButton = new JRadioButton(VWSIMResource.s_checkIn);
            this.m_checkInRadioButton.setSelected(true);
            buttonGroup.add(this.m_checkInRadioButton);
            this.m_checkInRadioButton.addActionListener(this);
            this.m_msgPanel.add((Component)this.m_checkInRadioButton, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 15, 0, 0);
            this.m_cancelCheckOutRadioButton = new JRadioButton(VWSIMResource.s_cancelCheckOut);
            this.m_cancelCheckOutRadioButton.setSelected(false);
            buttonGroup.add(this.m_cancelCheckOutRadioButton);
            this.m_cancelCheckOutRadioButton.addActionListener(this);
            this.m_msgPanel.add((Component)this.m_cancelCheckOutRadioButton, gbCons);
            ++gbCons.gridy;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(15, 15, 0, 0);
            this.m_msg2 = new JLabel();
            this.m_msgPanel.add((Component)this.m_msg2, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initButtons() {
        try {
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 1;
            this.m_gbCons.fill = 0;
            this.m_gbCons.weightx = 0.0;
            this.m_gbCons.weighty = 0.0;
            this.m_gbCons.anchor = 20;
            this.m_gbCons.gridwidth = 2;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.insets = new Insets(0, 5, 5, 5);
            this.m_buttons = new VWDialogButtons(35);
            this.m_buttons.addDialogButtonsActionListener(this);
            this.getContentPane().add((Component)this.m_buttons, this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_checkInRadioButton) {
            this.m_status = 500;
        } else if (src == this.m_cancelCheckOutRadioButton) {
            this.m_status = 501;
        }
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        int id = event.getID();
        switch (id) {
            case 1: {
                this.m_result = 100;
                this.setVisible(false);
                break;
            }
            case 2: {
                this.m_result = 103;
                this.setVisible(false);
                break;
            }
            case 32: {
                this.performHelpAction();
            }
        }
    }

    private void performHelpAction() {
        try {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "vwsimidmnewconfirmdialog.htm");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setMessage(String msg) {
        this.m_msg2.setText(msg);
    }
}

